package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait AlertCategory {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.AlertCategory
}
object AlertCategory {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.AlertCategory
  ): zio.aws.mediatailor.model.AlertCategory = value match {
    case software.amazon.awssdk.services.mediatailor.model.AlertCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.AlertCategory.SCHEDULING_ERROR =>
      val r = SCHEDULING_ERROR
      r
    case software.amazon.awssdk.services.mediatailor.model.AlertCategory.PLAYBACK_WARNING =>
      val r = PLAYBACK_WARNING
      r
    case software.amazon.awssdk.services.mediatailor.model.AlertCategory.INFO =>
      val r = INFO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.AlertCategory {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AlertCategory =
      software.amazon.awssdk.services.mediatailor.model.AlertCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object SCHEDULING_ERROR extends zio.aws.mediatailor.model.AlertCategory {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AlertCategory =
      software.amazon.awssdk.services.mediatailor.model.AlertCategory.SCHEDULING_ERROR
  }
  case object PLAYBACK_WARNING extends zio.aws.mediatailor.model.AlertCategory {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AlertCategory =
      software.amazon.awssdk.services.mediatailor.model.AlertCategory.PLAYBACK_WARNING
  }
  case object INFO extends zio.aws.mediatailor.model.AlertCategory {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AlertCategory =
      software.amazon.awssdk.services.mediatailor.model.AlertCategory.INFO
  }
}
