package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait AdMarkupType {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.AdMarkupType
}
object AdMarkupType {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.AdMarkupType
  ): zio.aws.mediatailor.model.AdMarkupType = value match {
    case software.amazon.awssdk.services.mediatailor.model.AdMarkupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.AdMarkupType.DATERANGE =>
      val r = DATERANGE
      r
    case software.amazon.awssdk.services.mediatailor.model.AdMarkupType.SCTE35_ENHANCED =>
      val r = SCTE35_ENHANCED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.AdMarkupType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AdMarkupType =
      software.amazon.awssdk.services.mediatailor.model.AdMarkupType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATERANGE extends zio.aws.mediatailor.model.AdMarkupType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AdMarkupType =
      software.amazon.awssdk.services.mediatailor.model.AdMarkupType.DATERANGE
  }
  case object SCTE35_ENHANCED extends zio.aws.mediatailor.model.AdMarkupType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AdMarkupType =
      software.amazon.awssdk.services.mediatailor.model.AdMarkupType.SCTE35_ENHANCED
  }
}
