package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait AccessType {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.AccessType
}
object AccessType {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.AccessType
  ): zio.aws.mediatailor.model.AccessType = value match {
    case software.amazon.awssdk.services.mediatailor.model.AccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.AccessType.S3_SIGV4 =>
      val r = S3_SIGV4
      r
    case software.amazon.awssdk.services.mediatailor.model.AccessType.SECRETS_MANAGER_ACCESS_TOKEN =>
      val r = SECRETS_MANAGER_ACCESS_TOKEN
      r
    case software.amazon.awssdk.services.mediatailor.model.AccessType.AUTODETECT_SIGV4 =>
      val r = AUTODETECT_SIGV4
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AccessType =
      software.amazon.awssdk.services.mediatailor.model.AccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3_SIGV4 extends zio.aws.mediatailor.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AccessType =
      software.amazon.awssdk.services.mediatailor.model.AccessType.S3_SIGV4
  }
  case object SECRETS_MANAGER_ACCESS_TOKEN
      extends zio.aws.mediatailor.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AccessType =
      software.amazon.awssdk.services.mediatailor.model.AccessType.SECRETS_MANAGER_ACCESS_TOKEN
  }
  case object AUTODETECT_SIGV4 extends zio.aws.mediatailor.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.AccessType =
      software.amazon.awssdk.services.mediatailor.model.AccessType.AUTODETECT_SIGV4
  }
}
