package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class PrefetchRetrieval(
    dynamicVariables: Optional[Map[__string, __string]] = Optional.Absent,
    endTime: __timestampUnix,
    startTime: Optional[__timestampUnix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval = {
    import PrefetchRetrieval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
      .builder()
      .optionallyWith(
        dynamicVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.dynamicVariables)
      .endTime(endTime: Instant)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly =
    zio.aws.mediatailor.model.PrefetchRetrieval.wrap(buildAwsValue())
}
object PrefetchRetrieval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.PrefetchRetrieval =
      zio.aws.mediatailor.model.PrefetchRetrieval(
        dynamicVariables.map(value => value),
        endTime,
        startTime.map(value => value)
      )
    def dynamicVariables: Optional[Map[__string, __string]]
    def endTime: __timestampUnix
    def startTime: Optional[__timestampUnix]
    def getDynamicVariables: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("dynamicVariables", dynamicVariables)
    def getEndTime: ZIO[Any, Nothing, __timestampUnix] = ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
  ) extends zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly {
    override val dynamicVariables: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamicVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val endTime: __timestampUnix = impl.endTime(): __timestampUnix
    override val startTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __timestampUnix)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
  ): zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly = new Wrapper(impl)
}
