package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListChannelsResponse(
    items: Optional[Iterable[zio.aws.mediatailor.model.Channel]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly =
    zio.aws.mediatailor.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListChannelsResponse =
      zio.aws.mediatailor.model.ListChannelsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mediatailor.model.Channel.ReadOnly]]
    def nextToken: Optional[__string]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse
  ) extends zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mediatailor.model.Channel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.Channel.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse
  ): zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly = new Wrapper(impl)
}
