package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KeyValuePair(key: String, value: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.KeyValuePair = {
    import KeyValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.KeyValuePair
      .builder()
      .key(key: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.KeyValuePair.ReadOnly =
    zio.aws.mediatailor.model.KeyValuePair.wrap(buildAwsValue())
}
object KeyValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.KeyValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.KeyValuePair =
      zio.aws.mediatailor.model.KeyValuePair(key, value)
    def key: String
    def value: String
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.KeyValuePair
  ) extends zio.aws.mediatailor.model.KeyValuePair.ReadOnly {
    override val key: String = impl.key(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.KeyValuePair
  ): zio.aws.mediatailor.model.KeyValuePair.ReadOnly = new Wrapper(impl)
}
