package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait FillPolicy {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.FillPolicy
}
object FillPolicy {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.FillPolicy
  ): zio.aws.mediatailor.model.FillPolicy = value match {
    case software.amazon.awssdk.services.mediatailor.model.FillPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.FillPolicy.FULL_AVAIL_ONLY =>
      val r = FULL_AVAIL_ONLY
      r
    case software.amazon.awssdk.services.mediatailor.model.FillPolicy.PARTIAL_AVAIL =>
      val r = PARTIAL_AVAIL
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.FillPolicy {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.FillPolicy =
      software.amazon.awssdk.services.mediatailor.model.FillPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_AVAIL_ONLY extends zio.aws.mediatailor.model.FillPolicy {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.FillPolicy =
      software.amazon.awssdk.services.mediatailor.model.FillPolicy.FULL_AVAIL_ONLY
  }
  case object PARTIAL_AVAIL extends zio.aws.mediatailor.model.FillPolicy {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.FillPolicy =
      software.amazon.awssdk.services.mediatailor.model.FillPolicy.PARTIAL_AVAIL
  }
}
