package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class DescribeVodSourceResponse(
    adBreakOpportunities: Optional[
      Iterable[zio.aws.mediatailor.model.AdBreakOpportunity]
    ] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    httpPackageConfigurations: Optional[
      Iterable[zio.aws.mediatailor.model.HttpPackageConfiguration]
    ] = Optional.Absent,
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    sourceLocationName: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    vodSourceName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse = {
    import DescribeVodSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse
      .builder()
      .optionallyWith(
        adBreakOpportunities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adBreakOpportunities)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        httpPackageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.httpPackageConfigurations)
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vodSourceName.map(value => value: java.lang.String))(
        _.vodSourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly =
    zio.aws.mediatailor.model.DescribeVodSourceResponse.wrap(buildAwsValue())
}
object DescribeVodSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DescribeVodSourceResponse =
      zio.aws.mediatailor.model.DescribeVodSourceResponse(
        adBreakOpportunities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value),
        creationTime.map(value => value),
        httpPackageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        sourceLocationName.map(value => value),
        tags.map(value => value),
        vodSourceName.map(value => value)
      )
    def adBreakOpportunities
        : Optional[List[zio.aws.mediatailor.model.AdBreakOpportunity.ReadOnly]]
    def arn: Optional[__string]
    def creationTime: Optional[__timestampUnix]
    def httpPackageConfigurations: Optional[
      List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    ]
    def lastModifiedTime: Optional[__timestampUnix]
    def sourceLocationName: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def vodSourceName: Optional[__string]
    def getAdBreakOpportunities: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.AdBreakOpportunity.ReadOnly
    ]] =
      AwsError.unwrapOptionField("adBreakOpportunities", adBreakOpportunities)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getHttpPackageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "httpPackageConfigurations",
      httpPackageConfigurations
    )
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse
  ) extends zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly {
    override val adBreakOpportunities: Optional[
      List[zio.aws.mediatailor.model.AdBreakOpportunity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adBreakOpportunities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.AdBreakOpportunity.wrap(item)
        }.toList
      )
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val httpPackageConfigurations: Optional[
      List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.httpPackageConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }.toList
      )
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val sourceLocationName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceLocationName())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val vodSourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vodSourceName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse
  ): zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
