package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait Mode {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.Mode
}
object Mode {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.Mode
  ): zio.aws.mediatailor.model.Mode = value match {
    case software.amazon.awssdk.services.mediatailor.model.Mode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.Mode.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.mediatailor.model.Mode.BEHIND_LIVE_EDGE =>
      val r = BEHIND_LIVE_EDGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Mode =
      software.amazon.awssdk.services.mediatailor.model.Mode.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.mediatailor.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Mode =
      software.amazon.awssdk.services.mediatailor.model.Mode.OFF
  }
  case object BEHIND_LIVE_EDGE extends zio.aws.mediatailor.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Mode =
      software.amazon.awssdk.services.mediatailor.model.Mode.BEHIND_LIVE_EDGE
  }
}
