package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.LogType
  ): zio.aws.mediatailor.model.LogType = value match {
    case software.amazon.awssdk.services.mediatailor.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.LogType.AS_RUN =>
      val r = AS_RUN
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.LogType =
      software.amazon.awssdk.services.mediatailor.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object AS_RUN extends zio.aws.mediatailor.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.LogType =
      software.amazon.awssdk.services.mediatailor.model.LogType.AS_RUN
  }
}
