package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class CreateLiveSourceResponse(
    arn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    httpPackageConfigurations: Optional[
      Iterable[zio.aws.mediatailor.model.HttpPackageConfiguration]
    ] = Optional.Absent,
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    liveSourceName: Optional[__string] = Optional.Absent,
    sourceLocationName: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceResponse = {
    import CreateLiveSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        httpPackageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.httpPackageConfigurations)
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(liveSourceName.map(value => value: java.lang.String))(
        _.liveSourceName
      )
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateLiveSourceResponse.ReadOnly =
    zio.aws.mediatailor.model.CreateLiveSourceResponse.wrap(buildAwsValue())
}
object CreateLiveSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateLiveSourceResponse =
      zio.aws.mediatailor.model.CreateLiveSourceResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        httpPackageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        liveSourceName.map(value => value),
        sourceLocationName.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def creationTime: Optional[__timestampUnix]
    def httpPackageConfigurations: Optional[
      List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    ]
    def lastModifiedTime: Optional[__timestampUnix]
    def liveSourceName: Optional[__string]
    def sourceLocationName: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getHttpPackageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "httpPackageConfigurations",
      httpPackageConfigurations
    )
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLiveSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("liveSourceName", liveSourceName)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceResponse
  ) extends zio.aws.mediatailor.model.CreateLiveSourceResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val httpPackageConfigurations: Optional[
      List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.httpPackageConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }.toList
      )
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val liveSourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.liveSourceName())
      .map(value => value: __string)
    override val sourceLocationName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceLocationName())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceResponse
  ): zio.aws.mediatailor.model.CreateLiveSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
