package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConfigureLogsForChannelRequest(
    channelName: __string,
    logTypes: Iterable[zio.aws.mediatailor.model.LogType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest = {
    import ConfigureLogsForChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest
      .builder()
      .channelName(channelName: java.lang.String)
      .logTypesWithStrings(logTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ConfigureLogsForChannelRequest.ReadOnly =
    zio.aws.mediatailor.model.ConfigureLogsForChannelRequest
      .wrap(buildAwsValue())
}
object ConfigureLogsForChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ConfigureLogsForChannelRequest =
      zio.aws.mediatailor.model
        .ConfigureLogsForChannelRequest(channelName, logTypes)
    def channelName: __string
    def logTypes: List[zio.aws.mediatailor.model.LogType]
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getLogTypes
        : ZIO[Any, Nothing, List[zio.aws.mediatailor.model.LogType]] =
      ZIO.succeed(logTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest
  ) extends zio.aws.mediatailor.model.ConfigureLogsForChannelRequest.ReadOnly {
    override val channelName: __string = impl.channelName(): __string
    override val logTypes: List[zio.aws.mediatailor.model.LogType] = impl
      .logTypes()
      .asScala
      .map { item =>
        zio.aws.mediatailor.model.LogType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest
  ): zio.aws.mediatailor.model.ConfigureLogsForChannelRequest.ReadOnly =
    new Wrapper(impl)
}
