package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__long
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateProgramTransition(
    durationMillis: Optional[__long] = Optional.Absent,
    scheduledStartTimeMillis: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateProgramTransition = {
    import UpdateProgramTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateProgramTransition
      .builder()
      .optionallyWith(durationMillis.map(value => value: java.lang.Long))(
        _.durationMillis
      )
      .optionallyWith(
        scheduledStartTimeMillis.map(value => value: java.lang.Long)
      )(_.scheduledStartTimeMillis)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateProgramTransition.ReadOnly =
    zio.aws.mediatailor.model.UpdateProgramTransition.wrap(buildAwsValue())
}
object UpdateProgramTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateProgramTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateProgramTransition =
      zio.aws.mediatailor.model.UpdateProgramTransition(
        durationMillis.map(value => value),
        scheduledStartTimeMillis.map(value => value)
      )
    def durationMillis: Optional[__long]
    def scheduledStartTimeMillis: Optional[__long]
    def getDurationMillis: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getScheduledStartTimeMillis: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("scheduledStartTimeMillis", scheduledStartTimeMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateProgramTransition
  ) extends zio.aws.mediatailor.model.UpdateProgramTransition.ReadOnly {
    override val durationMillis: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMillis())
      .map(value => value: __long)
    override val scheduledStartTimeMillis: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledStartTimeMillis())
        .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateProgramTransition
  ): zio.aws.mediatailor.model.UpdateProgramTransition.ReadOnly = new Wrapper(
    impl
  )
}
