package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateProgramRequest(
    adBreaks: Optional[Iterable[zio.aws.mediatailor.model.AdBreak]] =
      Optional.Absent,
    channelName: __string,
    programName: __string,
    scheduleConfiguration: zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest = {
    import UpdateProgramRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest
      .builder()
      .optionallyWith(
        adBreaks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adBreaks)
      .channelName(channelName: java.lang.String)
      .programName(programName: java.lang.String)
      .scheduleConfiguration(scheduleConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateProgramRequest.ReadOnly =
    zio.aws.mediatailor.model.UpdateProgramRequest.wrap(buildAwsValue())
}
object UpdateProgramRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateProgramRequest =
      zio.aws.mediatailor.model.UpdateProgramRequest(
        adBreaks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelName,
        programName,
        scheduleConfiguration.asEditable
      )
    def adBreaks: Optional[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]]
    def channelName: __string
    def programName: __string
    def scheduleConfiguration
        : zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration.ReadOnly
    def getAdBreaks
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      AwsError.unwrapOptionField("adBreaks", adBreaks)
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getProgramName: ZIO[Any, Nothing, __string] = ZIO.succeed(programName)
    def getScheduleConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration.ReadOnly
    ] = ZIO.succeed(scheduleConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest
  ) extends zio.aws.mediatailor.model.UpdateProgramRequest.ReadOnly {
    override val adBreaks
        : Optional[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adBreaks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.AdBreak.wrap(item)
          }.toList
        )
    override val channelName: __string = impl.channelName(): __string
    override val programName: __string = impl.programName(): __string
    override val scheduleConfiguration
        : zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration.ReadOnly =
      zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration
        .wrap(impl.scheduleConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest
  ): zio.aws.mediatailor.model.UpdateProgramRequest.ReadOnly = new Wrapper(impl)
}
