package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScheduleConfiguration(
    clipRange: Optional[zio.aws.mediatailor.model.ClipRange] = Optional.Absent,
    transition: zio.aws.mediatailor.model.Transition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration = {
    import ScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
      .builder()
      .optionallyWith(clipRange.map(value => value.buildAwsValue()))(
        _.clipRange
      )
      .transition(transition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly =
    zio.aws.mediatailor.model.ScheduleConfiguration.wrap(buildAwsValue())
}
object ScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ScheduleConfiguration =
      zio.aws.mediatailor.model.ScheduleConfiguration(
        clipRange.map(value => value.asEditable),
        transition.asEditable
      )
    def clipRange: Optional[zio.aws.mediatailor.model.ClipRange.ReadOnly]
    def transition: zio.aws.mediatailor.model.Transition.ReadOnly
    def getClipRange
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.ClipRange.ReadOnly] =
      AwsError.unwrapOptionField("clipRange", clipRange)
    def getTransition
        : ZIO[Any, Nothing, zio.aws.mediatailor.model.Transition.ReadOnly] =
      ZIO.succeed(transition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
  ) extends zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly {
    override val clipRange
        : Optional[zio.aws.mediatailor.model.ClipRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clipRange())
        .map(value => zio.aws.mediatailor.model.ClipRange.wrap(value))
    override val transition: zio.aws.mediatailor.model.Transition.ReadOnly =
      zio.aws.mediatailor.model.Transition.wrap(impl.transition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
  ): zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
