package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPlaybackConfigurationsResponse(
    items: Optional[Iterable[zio.aws.mediatailor.model.PlaybackConfiguration]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse = {
    import ListPlaybackConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly =
    zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListPlaybackConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse =
      zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[
      List[zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly]
    ]
    def nextToken: Optional[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
  ) extends zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.PlaybackConfiguration.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
  ): zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
