package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__long
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AdBreak(
    messageType: Optional[zio.aws.mediatailor.model.MessageType] =
      Optional.Absent,
    offsetMillis: Optional[__long] = Optional.Absent,
    slate: Optional[zio.aws.mediatailor.model.SlateSource] = Optional.Absent,
    spliceInsertMessage: Optional[
      zio.aws.mediatailor.model.SpliceInsertMessage
    ] = Optional.Absent,
    timeSignalMessage: Optional[zio.aws.mediatailor.model.TimeSignalMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.AdBreak = {
    import AdBreak.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.AdBreak
      .builder()
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(offsetMillis.map(value => value: java.lang.Long))(
        _.offsetMillis
      )
      .optionallyWith(slate.map(value => value.buildAwsValue()))(_.slate)
      .optionallyWith(spliceInsertMessage.map(value => value.buildAwsValue()))(
        _.spliceInsertMessage
      )
      .optionallyWith(timeSignalMessage.map(value => value.buildAwsValue()))(
        _.timeSignalMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.AdBreak.ReadOnly =
    zio.aws.mediatailor.model.AdBreak.wrap(buildAwsValue())
}
object AdBreak {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.AdBreak
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.AdBreak =
      zio.aws.mediatailor.model.AdBreak(
        messageType.map(value => value),
        offsetMillis.map(value => value),
        slate.map(value => value.asEditable),
        spliceInsertMessage.map(value => value.asEditable),
        timeSignalMessage.map(value => value.asEditable)
      )
    def messageType: Optional[zio.aws.mediatailor.model.MessageType]
    def offsetMillis: Optional[__long]
    def slate: Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def spliceInsertMessage
        : Optional[zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly]
    def timeSignalMessage
        : Optional[zio.aws.mediatailor.model.TimeSignalMessage.ReadOnly]
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getOffsetMillis: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("offsetMillis", offsetMillis)
    def getSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("slate", slate)
    def getSpliceInsertMessage: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly
    ] = AwsError.unwrapOptionField("spliceInsertMessage", spliceInsertMessage)
    def getTimeSignalMessage: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.TimeSignalMessage.ReadOnly
    ] = AwsError.unwrapOptionField("timeSignalMessage", timeSignalMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.AdBreak
  ) extends zio.aws.mediatailor.model.AdBreak.ReadOnly {
    override val messageType: Optional[zio.aws.mediatailor.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.mediatailor.model.MessageType.wrap(value))
    override val offsetMillis: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.offsetMillis())
      .map(value => value: __long)
    override val slate
        : Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slate())
        .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val spliceInsertMessage
        : Optional[zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spliceInsertMessage())
        .map(value => zio.aws.mediatailor.model.SpliceInsertMessage.wrap(value))
    override val timeSignalMessage
        : Optional[zio.aws.mediatailor.model.TimeSignalMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSignalMessage())
        .map(value => zio.aws.mediatailor.model.TimeSignalMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.AdBreak
  ): zio.aws.mediatailor.model.AdBreak.ReadOnly = new Wrapper(impl)
}
