package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogConfigurationForChannel(
    logTypes: Optional[Iterable[zio.aws.mediatailor.model.LogType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.LogConfigurationForChannel = {
    import LogConfigurationForChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.LogConfigurationForChannel
      .builder()
      .optionallyWith(
        logTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.logTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.LogConfigurationForChannel.ReadOnly =
    zio.aws.mediatailor.model.LogConfigurationForChannel.wrap(buildAwsValue())
}
object LogConfigurationForChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.LogConfigurationForChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.LogConfigurationForChannel =
      zio.aws.mediatailor.model
        .LogConfigurationForChannel(logTypes.map(value => value))
    def logTypes: Optional[List[zio.aws.mediatailor.model.LogType]]
    def getLogTypes
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.LogType]] =
      AwsError.unwrapOptionField("logTypes", logTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.LogConfigurationForChannel
  ) extends zio.aws.mediatailor.model.LogConfigurationForChannel.ReadOnly {
    override val logTypes: Optional[List[zio.aws.mediatailor.model.LogType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.LogType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.LogConfigurationForChannel
  ): zio.aws.mediatailor.model.LogConfigurationForChannel.ReadOnly =
    new Wrapper(impl)
}
