package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__integer, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LivePreRollConfiguration(
    adDecisionServerUrl: Optional[__string] = Optional.Absent,
    maxDurationSeconds: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration = {
    import LivePreRollConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
      .builder()
      .optionallyWith(
        adDecisionServerUrl.map(value => value: java.lang.String)
      )(_.adDecisionServerUrl)
      .optionallyWith(maxDurationSeconds.map(value => value: Integer))(
        _.maxDurationSeconds
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly =
    zio.aws.mediatailor.model.LivePreRollConfiguration.wrap(buildAwsValue())
}
object LivePreRollConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.LivePreRollConfiguration =
      zio.aws.mediatailor.model.LivePreRollConfiguration(
        adDecisionServerUrl.map(value => value),
        maxDurationSeconds.map(value => value)
      )
    def adDecisionServerUrl: Optional[__string]
    def maxDurationSeconds: Optional[__integer]
    def getAdDecisionServerUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("adDecisionServerUrl", adDecisionServerUrl)
    def getMaxDurationSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxDurationSeconds", maxDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
  ) extends zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly {
    override val adDecisionServerUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.adDecisionServerUrl())
      .map(value => value: __string)
    override val maxDurationSeconds: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxDurationSeconds())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
  ): zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
