package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAlertsResponse(
    items: Optional[Iterable[zio.aws.mediatailor.model.Alert]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse = {
    import ListAlertsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly =
    zio.aws.mediatailor.model.ListAlertsResponse.wrap(buildAwsValue())
}
object ListAlertsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListAlertsResponse =
      zio.aws.mediatailor.model.ListAlertsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mediatailor.model.Alert.ReadOnly]]
    def nextToken: Optional[__string]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.Alert.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse
  ) extends zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mediatailor.model.Alert.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.Alert.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse
  ): zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly = new Wrapper(impl)
}
