package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HlsConfiguration(
    manifestEndpointPrefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.HlsConfiguration = {
    import HlsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
      .builder()
      .optionallyWith(
        manifestEndpointPrefix.map(value => value: java.lang.String)
      )(_.manifestEndpointPrefix)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.HlsConfiguration.ReadOnly =
    zio.aws.mediatailor.model.HlsConfiguration.wrap(buildAwsValue())
}
object HlsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.HlsConfiguration =
      zio.aws.mediatailor.model
        .HlsConfiguration(manifestEndpointPrefix.map(value => value))
    def manifestEndpointPrefix: Optional[__string]
    def getManifestEndpointPrefix: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("manifestEndpointPrefix", manifestEndpointPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
  ) extends zio.aws.mediatailor.model.HlsConfiguration.ReadOnly {
    override val manifestEndpointPrefix: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestEndpointPrefix())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
  ): zio.aws.mediatailor.model.HlsConfiguration.ReadOnly = new Wrapper(impl)
}
