package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigureLogsForChannelResponse(
    channelName: Optional[__string] = Optional.Absent,
    logTypes: Optional[Iterable[zio.aws.mediatailor.model.LogType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelResponse = {
    import ConfigureLogsForChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelResponse
      .builder()
      .optionallyWith(channelName.map(value => value: java.lang.String))(
        _.channelName
      )
      .optionallyWith(
        logTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.logTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.ReadOnly =
    zio.aws.mediatailor.model.ConfigureLogsForChannelResponse
      .wrap(buildAwsValue())
}
object ConfigureLogsForChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ConfigureLogsForChannelResponse =
      zio.aws.mediatailor.model.ConfigureLogsForChannelResponse(
        channelName.map(value => value),
        logTypes.map(value => value)
      )
    def channelName: Optional[__string]
    def logTypes: Optional[List[zio.aws.mediatailor.model.LogType]]
    def getChannelName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getLogTypes
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.LogType]] =
      AwsError.unwrapOptionField("logTypes", logTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelResponse
  ) extends zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.ReadOnly {
    override val channelName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => value: __string)
    override val logTypes: Optional[List[zio.aws.mediatailor.model.LogType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.LogType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelResponse
  ): zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.ReadOnly =
    new Wrapper(impl)
}
