package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CdnConfiguration(
    adSegmentUrlPrefix: Optional[__string] = Optional.Absent,
    contentSegmentUrlPrefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CdnConfiguration = {
    import CdnConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CdnConfiguration
      .builder()
      .optionallyWith(adSegmentUrlPrefix.map(value => value: java.lang.String))(
        _.adSegmentUrlPrefix
      )
      .optionallyWith(
        contentSegmentUrlPrefix.map(value => value: java.lang.String)
      )(_.contentSegmentUrlPrefix)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CdnConfiguration.ReadOnly =
    zio.aws.mediatailor.model.CdnConfiguration.wrap(buildAwsValue())
}
object CdnConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CdnConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CdnConfiguration =
      zio.aws.mediatailor.model.CdnConfiguration(
        adSegmentUrlPrefix.map(value => value),
        contentSegmentUrlPrefix.map(value => value)
      )
    def adSegmentUrlPrefix: Optional[__string]
    def contentSegmentUrlPrefix: Optional[__string]
    def getAdSegmentUrlPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("adSegmentUrlPrefix", adSegmentUrlPrefix)
    def getContentSegmentUrlPrefix: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("contentSegmentUrlPrefix", contentSegmentUrlPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CdnConfiguration
  ) extends zio.aws.mediatailor.model.CdnConfiguration.ReadOnly {
    override val adSegmentUrlPrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.adSegmentUrlPrefix())
      .map(value => value: __string)
    override val contentSegmentUrlPrefix: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentSegmentUrlPrefix())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CdnConfiguration
  ): zio.aws.mediatailor.model.CdnConfiguration.ReadOnly = new Wrapper(impl)
}
