package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TimeSignalMessage(
    segmentationDescriptors: Optional[
      Iterable[zio.aws.mediatailor.model.SegmentationDescriptor]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.TimeSignalMessage = {
    import TimeSignalMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.TimeSignalMessage
      .builder()
      .optionallyWith(
        segmentationDescriptors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentationDescriptors)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.TimeSignalMessage.ReadOnly =
    zio.aws.mediatailor.model.TimeSignalMessage.wrap(buildAwsValue())
}
object TimeSignalMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.TimeSignalMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.TimeSignalMessage =
      zio.aws.mediatailor.model.TimeSignalMessage(
        segmentationDescriptors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def segmentationDescriptors: Optional[
      List[zio.aws.mediatailor.model.SegmentationDescriptor.ReadOnly]
    ]
    def getSegmentationDescriptors: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.SegmentationDescriptor.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "segmentationDescriptors",
      segmentationDescriptors
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.TimeSignalMessage
  ) extends zio.aws.mediatailor.model.TimeSignalMessage.ReadOnly {
    override val segmentationDescriptors: Optional[
      List[zio.aws.mediatailor.model.SegmentationDescriptor.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentationDescriptors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.SegmentationDescriptor.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.TimeSignalMessage
  ): zio.aws.mediatailor.model.TimeSignalMessage.ReadOnly = new Wrapper(impl)
}
