package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait RelativePosition {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.RelativePosition
}
object RelativePosition {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.RelativePosition
  ): zio.aws.mediatailor.model.RelativePosition = value match {
    case software.amazon.awssdk.services.mediatailor.model.RelativePosition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.RelativePosition.BEFORE_PROGRAM =>
      val r = BEFORE_PROGRAM
      r
    case software.amazon.awssdk.services.mediatailor.model.RelativePosition.AFTER_PROGRAM =>
      val r = AFTER_PROGRAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.RelativePosition {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.RelativePosition =
      software.amazon.awssdk.services.mediatailor.model.RelativePosition.UNKNOWN_TO_SDK_VERSION
  }
  case object BEFORE_PROGRAM
      extends zio.aws.mediatailor.model.RelativePosition {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.RelativePosition =
      software.amazon.awssdk.services.mediatailor.model.RelativePosition.BEFORE_PROGRAM
  }
  case object AFTER_PROGRAM extends zio.aws.mediatailor.model.RelativePosition {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.RelativePosition =
      software.amazon.awssdk.services.mediatailor.model.RelativePosition.AFTER_PROGRAM
  }
}
