package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetChannelPolicyResponse(
    policy: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse = {
    import GetChannelPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly =
    zio.aws.mediatailor.model.GetChannelPolicyResponse.wrap(buildAwsValue())
}
object GetChannelPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.GetChannelPolicyResponse =
      zio.aws.mediatailor.model
        .GetChannelPolicyResponse(policy.map(value => value))
    def policy: Optional[__string]
    def getPolicy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse
  ) extends zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly {
    override val policy: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse
  ): zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
