package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class DescribeSourceLocationResponse(
    accessConfiguration: Optional[
      zio.aws.mediatailor.model.AccessConfiguration
    ] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = Optional.Absent,
    httpConfiguration: Optional[zio.aws.mediatailor.model.HttpConfiguration] =
      Optional.Absent,
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    segmentDeliveryConfigurations: Optional[
      Iterable[zio.aws.mediatailor.model.SegmentDeliveryConfiguration]
    ] = Optional.Absent,
    sourceLocationName: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse = {
    import DescribeSourceLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .optionallyWith(httpConfiguration.map(value => value.buildAwsValue()))(
        _.httpConfiguration
      )
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentDeliveryConfigurations)
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly =
    zio.aws.mediatailor.model.DescribeSourceLocationResponse
      .wrap(buildAwsValue())
}
object DescribeSourceLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DescribeSourceLocationResponse =
      zio.aws.mediatailor.model.DescribeSourceLocationResponse(
        accessConfiguration.map(value => value.asEditable),
        arn.map(value => value),
        creationTime.map(value => value),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceLocationName.map(value => value),
        tags.map(value => value)
      )
    def accessConfiguration
        : Optional[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def arn: Optional[__string]
    def creationTime: Optional[__timestampUnix]
    def defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration
        : Optional[zio.aws.mediatailor.model.HttpConfiguration.ReadOnly]
    def lastModifiedTime: Optional[__timestampUnix]
    def segmentDeliveryConfigurations: Optional[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ]
    def sourceLocationName: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("httpConfiguration", httpConfiguration)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSegmentDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "segmentDeliveryConfigurations",
      segmentDeliveryConfigurations
    )
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse
  ) extends zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly {
    override val accessConfiguration
        : Optional[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessConfiguration())
        .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : Optional[zio.aws.mediatailor.model.HttpConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpConfiguration())
        .map(value => zio.aws.mediatailor.model.HttpConfiguration.wrap(value))
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val segmentDeliveryConfigurations: Optional[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.SegmentDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val sourceLocationName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceLocationName())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse
  ): zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly =
    new Wrapper(impl)
}
