package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessConfiguration(
    accessType: Optional[zio.aws.mediatailor.model.AccessType] =
      Optional.Absent,
    secretsManagerAccessTokenConfiguration: Optional[
      zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.AccessConfiguration = {
    import AccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.AccessConfiguration
      .builder()
      .optionallyWith(accessType.map(value => value.unwrap))(_.accessType)
      .optionallyWith(
        secretsManagerAccessTokenConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.secretsManagerAccessTokenConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.AccessConfiguration.ReadOnly =
    zio.aws.mediatailor.model.AccessConfiguration.wrap(buildAwsValue())
}
object AccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.AccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.AccessConfiguration =
      zio.aws.mediatailor.model.AccessConfiguration(
        accessType.map(value => value),
        secretsManagerAccessTokenConfiguration.map(value => value.asEditable)
      )
    def accessType: Optional[zio.aws.mediatailor.model.AccessType]
    def secretsManagerAccessTokenConfiguration: Optional[
      zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration.ReadOnly
    ]
    def getAccessType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.AccessType] =
      AwsError.unwrapOptionField("accessType", accessType)
    def getSecretsManagerAccessTokenConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "secretsManagerAccessTokenConfiguration",
      secretsManagerAccessTokenConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.AccessConfiguration
  ) extends zio.aws.mediatailor.model.AccessConfiguration.ReadOnly {
    override val accessType: Optional[zio.aws.mediatailor.model.AccessType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessType())
        .map(value => zio.aws.mediatailor.model.AccessType.wrap(value))
    override val secretsManagerAccessTokenConfiguration: Optional[
      zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerAccessTokenConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.AccessConfiguration
  ): zio.aws.mediatailor.model.AccessConfiguration.ReadOnly = new Wrapper(impl)
}
