package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPrefetchScheduleResponse(
    arn: Optional[__string] = Optional.Absent,
    consumption: Optional[zio.aws.mediatailor.model.PrefetchConsumption] =
      Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    playbackConfigurationName: Optional[__string] = Optional.Absent,
    retrieval: Optional[zio.aws.mediatailor.model.PrefetchRetrieval] =
      Optional.Absent,
    streamId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse = {
    import GetPrefetchScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(consumption.map(value => value.buildAwsValue()))(
        _.consumption
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        playbackConfigurationName.map(value => value: java.lang.String)
      )(_.playbackConfigurationName)
      .optionallyWith(retrieval.map(value => value.buildAwsValue()))(
        _.retrieval
      )
      .optionallyWith(streamId.map(value => value: java.lang.String))(
        _.streamId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.GetPrefetchScheduleResponse.ReadOnly =
    zio.aws.mediatailor.model.GetPrefetchScheduleResponse.wrap(buildAwsValue())
}
object GetPrefetchScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.GetPrefetchScheduleResponse =
      zio.aws.mediatailor.model.GetPrefetchScheduleResponse(
        arn.map(value => value),
        consumption.map(value => value.asEditable),
        name.map(value => value),
        playbackConfigurationName.map(value => value),
        retrieval.map(value => value.asEditable),
        streamId.map(value => value)
      )
    def arn: Optional[__string]
    def consumption
        : Optional[zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly]
    def name: Optional[__string]
    def playbackConfigurationName: Optional[__string]
    def retrieval
        : Optional[zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly]
    def streamId: Optional[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getConsumption: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly
    ] = AwsError.unwrapOptionField("consumption", consumption)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPlaybackConfigurationName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("playbackConfigurationName", playbackConfigurationName)
    def getRetrieval: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly
    ] = AwsError.unwrapOptionField("retrieval", retrieval)
    def getStreamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse
  ) extends zio.aws.mediatailor.model.GetPrefetchScheduleResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val consumption
        : Optional[zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumption())
        .map(value => zio.aws.mediatailor.model.PrefetchConsumption.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val playbackConfigurationName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playbackConfigurationName())
        .map(value => value: __string)
    override val retrieval
        : Optional[zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrieval())
        .map(value => zio.aws.mediatailor.model.PrefetchRetrieval.wrap(value))
    override val streamId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse
  ): zio.aws.mediatailor.model.GetPrefetchScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
