package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSourceLocationRequest(
    accessConfiguration: Optional[
      zio.aws.mediatailor.model.AccessConfiguration
    ] = Optional.Absent,
    defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = Optional.Absent,
    httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration,
    segmentDeliveryConfigurations: Optional[
      Iterable[zio.aws.mediatailor.model.SegmentDeliveryConfiguration]
    ] = Optional.Absent,
    sourceLocationName: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest = {
    import CreateSourceLocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .httpConfiguration(httpConfiguration.buildAwsValue())
      .optionallyWith(
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentDeliveryConfigurations)
      .sourceLocationName(sourceLocationName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.CreateSourceLocationRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateSourceLocationRequest.wrap(buildAwsValue())
}
object CreateSourceLocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateSourceLocationRequest =
      zio.aws.mediatailor.model.CreateSourceLocationRequest(
        accessConfiguration.map(value => value.asEditable),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.asEditable,
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceLocationName,
        tags.map(value => value)
      )
    def accessConfiguration
        : Optional[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    def segmentDeliveryConfigurations: Optional[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ]
    def sourceLocationName: __string
    def tags: Optional[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = ZIO.succeed(httpConfiguration)
    def getSegmentDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "segmentDeliveryConfigurations",
      segmentDeliveryConfigurations
    )
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
  ) extends zio.aws.mediatailor.model.CreateSourceLocationRequest.ReadOnly {
    override val accessConfiguration
        : Optional[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessConfiguration())
        .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : zio.aws.mediatailor.model.HttpConfiguration.ReadOnly =
      zio.aws.mediatailor.model.HttpConfiguration.wrap(impl.httpConfiguration())
    override val segmentDeliveryConfigurations: Optional[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.SegmentDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
  ): zio.aws.mediatailor.model.CreateSourceLocationRequest.ReadOnly =
    new Wrapper(impl)
}
