package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class VodSource(
    arn: __string,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    httpPackageConfigurations: Iterable[
      zio.aws.mediatailor.model.HttpPackageConfiguration
    ],
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    sourceLocationName: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    vodSourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.VodSource = {
    import VodSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.VodSource
      .builder()
      .arn(arn: java.lang.String)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .httpPackageConfigurations(httpPackageConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .sourceLocationName(sourceLocationName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vodSourceName(vodSourceName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.VodSource.ReadOnly =
    zio.aws.mediatailor.model.VodSource.wrap(buildAwsValue())
}
object VodSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.VodSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.VodSource =
      zio.aws.mediatailor.model.VodSource(
        arn,
        creationTime.map(value => value),
        httpPackageConfigurations.map { item =>
          item.asEditable
        },
        lastModifiedTime.map(value => value),
        sourceLocationName,
        tags.map(value => value),
        vodSourceName
      )
    def arn: __string
    def creationTime: Optional[__timestampUnix]
    def httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    def lastModifiedTime: Optional[__timestampUnix]
    def sourceLocationName: __string
    def tags: Optional[Map[__string, __string]]
    def vodSourceName: __string
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getHttpPackageConfigurations: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = ZIO.succeed(httpPackageConfigurations)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVodSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.VodSource
  ) extends zio.aws.mediatailor.model.VodSource.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly] =
      impl
        .httpPackageConfigurations()
        .asScala
        .map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }
        .toList
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val vodSourceName: __string = impl.vodSourceName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.VodSource
  ): zio.aws.mediatailor.model.VodSource.ReadOnly = new Wrapper(impl)
}
