package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SegmentationDescriptor(
    segmentNum: Optional[Integer] = Optional.Absent,
    segmentationEventId: Optional[Integer] = Optional.Absent,
    segmentationTypeId: Optional[Integer] = Optional.Absent,
    segmentationUpid: Optional[String] = Optional.Absent,
    segmentationUpidType: Optional[Integer] = Optional.Absent,
    segmentsExpected: Optional[Integer] = Optional.Absent,
    subSegmentNum: Optional[Integer] = Optional.Absent,
    subSegmentsExpected: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor = {
    import SegmentationDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor
      .builder()
      .optionallyWith(segmentNum.map(value => value: java.lang.Integer))(
        _.segmentNum
      )
      .optionallyWith(
        segmentationEventId.map(value => value: java.lang.Integer)
      )(_.segmentationEventId)
      .optionallyWith(
        segmentationTypeId.map(value => value: java.lang.Integer)
      )(_.segmentationTypeId)
      .optionallyWith(segmentationUpid.map(value => value: java.lang.String))(
        _.segmentationUpid
      )
      .optionallyWith(
        segmentationUpidType.map(value => value: java.lang.Integer)
      )(_.segmentationUpidType)
      .optionallyWith(segmentsExpected.map(value => value: java.lang.Integer))(
        _.segmentsExpected
      )
      .optionallyWith(subSegmentNum.map(value => value: java.lang.Integer))(
        _.subSegmentNum
      )
      .optionallyWith(
        subSegmentsExpected.map(value => value: java.lang.Integer)
      )(_.subSegmentsExpected)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.SegmentationDescriptor.ReadOnly =
    zio.aws.mediatailor.model.SegmentationDescriptor.wrap(buildAwsValue())
}
object SegmentationDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SegmentationDescriptor =
      zio.aws.mediatailor.model.SegmentationDescriptor(
        segmentNum.map(value => value),
        segmentationEventId.map(value => value),
        segmentationTypeId.map(value => value),
        segmentationUpid.map(value => value),
        segmentationUpidType.map(value => value),
        segmentsExpected.map(value => value),
        subSegmentNum.map(value => value),
        subSegmentsExpected.map(value => value)
      )
    def segmentNum: Optional[Integer]
    def segmentationEventId: Optional[Integer]
    def segmentationTypeId: Optional[Integer]
    def segmentationUpid: Optional[String]
    def segmentationUpidType: Optional[Integer]
    def segmentsExpected: Optional[Integer]
    def subSegmentNum: Optional[Integer]
    def subSegmentsExpected: Optional[Integer]
    def getSegmentNum: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("segmentNum", segmentNum)
    def getSegmentationEventId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("segmentationEventId", segmentationEventId)
    def getSegmentationTypeId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("segmentationTypeId", segmentationTypeId)
    def getSegmentationUpid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("segmentationUpid", segmentationUpid)
    def getSegmentationUpidType: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("segmentationUpidType", segmentationUpidType)
    def getSegmentsExpected: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("segmentsExpected", segmentsExpected)
    def getSubSegmentNum: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("subSegmentNum", subSegmentNum)
    def getSubSegmentsExpected: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("subSegmentsExpected", subSegmentsExpected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor
  ) extends zio.aws.mediatailor.model.SegmentationDescriptor.ReadOnly {
    override val segmentNum: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentNum())
      .map(value => value: Integer)
    override val segmentationEventId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentationEventId())
      .map(value => value: Integer)
    override val segmentationTypeId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentationTypeId())
      .map(value => value: Integer)
    override val segmentationUpid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentationUpid())
      .map(value => value: String)
    override val segmentationUpidType: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentationUpidType())
      .map(value => value: Integer)
    override val segmentsExpected: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentsExpected())
      .map(value => value: Integer)
    override val subSegmentNum: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.subSegmentNum())
      .map(value => value: Integer)
    override val subSegmentsExpected: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.subSegmentsExpected())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor
  ): zio.aws.mediatailor.model.SegmentationDescriptor.ReadOnly = new Wrapper(
    impl
  )
}
