package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__string, __integerMin1Max100}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPrefetchSchedulesRequest(
    maxResults: Optional[__integerMin1Max100] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    playbackConfigurationName: __string,
    streamId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest = {
    import ListPrefetchSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .playbackConfigurationName(playbackConfigurationName: java.lang.String)
      .optionallyWith(streamId.map(value => value: java.lang.String))(
        _.streamId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.ReadOnly =
    zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.wrap(buildAwsValue())
}
object ListPrefetchSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListPrefetchSchedulesRequest =
      zio.aws.mediatailor.model.ListPrefetchSchedulesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        playbackConfigurationName,
        streamId.map(value => value)
      )
    def maxResults: Optional[__integerMin1Max100]
    def nextToken: Optional[__string]
    def playbackConfigurationName: __string
    def streamId: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, __integerMin1Max100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPlaybackConfigurationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(playbackConfigurationName)
    def getStreamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
  ) extends zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.ReadOnly {
    override val maxResults: Optional[__integerMin1Max100] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => value: __integerMin1Max100)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val playbackConfigurationName: __string =
      impl.playbackConfigurationName(): __string
    override val streamId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
  ): zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.ReadOnly =
    new Wrapper(impl)
}
