package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DashConfiguration(
    manifestEndpointPrefix: Optional[__string] = Optional.Absent,
    mpdLocation: Optional[__string] = Optional.Absent,
    originManifestType: Optional[zio.aws.mediatailor.model.OriginManifestType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DashConfiguration = {
    import DashConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DashConfiguration
      .builder()
      .optionallyWith(
        manifestEndpointPrefix.map(value => value: java.lang.String)
      )(_.manifestEndpointPrefix)
      .optionallyWith(mpdLocation.map(value => value: java.lang.String))(
        _.mpdLocation
      )
      .optionallyWith(originManifestType.map(value => value.unwrap))(
        _.originManifestType
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DashConfiguration.ReadOnly =
    zio.aws.mediatailor.model.DashConfiguration.wrap(buildAwsValue())
}
object DashConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DashConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DashConfiguration =
      zio.aws.mediatailor.model.DashConfiguration(
        manifestEndpointPrefix.map(value => value),
        mpdLocation.map(value => value),
        originManifestType.map(value => value)
      )
    def manifestEndpointPrefix: Optional[__string]
    def mpdLocation: Optional[__string]
    def originManifestType
        : Optional[zio.aws.mediatailor.model.OriginManifestType]
    def getManifestEndpointPrefix: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("manifestEndpointPrefix", manifestEndpointPrefix)
    def getMpdLocation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mpdLocation", mpdLocation)
    def getOriginManifestType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.OriginManifestType] =
      AwsError.unwrapOptionField("originManifestType", originManifestType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DashConfiguration
  ) extends zio.aws.mediatailor.model.DashConfiguration.ReadOnly {
    override val manifestEndpointPrefix: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestEndpointPrefix())
        .map(value => value: __string)
    override val mpdLocation: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.mpdLocation())
      .map(value => value: __string)
    override val originManifestType
        : Optional[zio.aws.mediatailor.model.OriginManifestType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originManifestType())
        .map(value => zio.aws.mediatailor.model.OriginManifestType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DashConfiguration
  ): zio.aws.mediatailor.model.DashConfiguration.ReadOnly = new Wrapper(impl)
}
