package zio.aws.mediatailor
import zio.aws.mediatailor.model.GetPrefetchScheduleResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.mediatailor.model.{
  PutPlaybackConfigurationRequest,
  CreateProgramRequest,
  UpdateLiveSourceRequest,
  StartChannelRequest,
  CreateVodSourceRequest,
  DeleteChannelPolicyRequest,
  CreateSourceLocationRequest,
  CreatePrefetchScheduleRequest,
  DeleteChannelRequest,
  ConfigureLogsForChannelRequest,
  DeleteSourceLocationRequest,
  CreateChannelRequest,
  DeleteVodSourceRequest,
  ListLiveSourcesRequest,
  ListTagsForResourceRequest,
  ListVodSourcesRequest,
  DescribeSourceLocationRequest,
  GetChannelScheduleRequest,
  GetPlaybackConfigurationRequest,
  ListPrefetchSchedulesRequest,
  CreateLiveSourceRequest,
  UpdateChannelRequest,
  ListPlaybackConfigurationsRequest,
  GetChannelPolicyRequest,
  UpdateSourceLocationRequest,
  UpdateProgramRequest,
  ListAlertsRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  UpdateVodSourceRequest,
  DeleteProgramRequest,
  DeletePrefetchScheduleRequest,
  StopChannelRequest,
  GetPrefetchScheduleRequest,
  DeletePlaybackConfigurationRequest,
  DeleteLiveSourceRequest,
  DescribeProgramRequest,
  DescribeLiveSourceRequest,
  DescribeChannelRequest,
  ListSourceLocationsRequest,
  PutChannelPolicyRequest,
  DescribeVodSourceRequest,
  TagResourceRequest,
  ConfigureLogsForPlaybackConfigurationRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.mediatailor.model.{
  PutPlaybackConfigurationResponse,
  ListLiveSourcesResponse,
  GetChannelPolicyResponse,
  CreateChannelResponse,
  DescribeProgramResponse,
  ConfigureLogsForPlaybackConfigurationResponse,
  UpdateChannelResponse,
  GetPlaybackConfigurationResponse,
  UpdateProgramResponse,
  DescribeSourceLocationResponse,
  ListChannelsResponse,
  ListAlertsResponse,
  VodSource,
  DeleteLiveSourceResponse,
  UpdateVodSourceResponse,
  CreateSourceLocationResponse,
  DescribeChannelResponse,
  Alert,
  DeleteSourceLocationResponse,
  CreateLiveSourceResponse,
  ScheduleEntry,
  DeletePrefetchScheduleResponse,
  CreatePrefetchScheduleResponse,
  StopChannelResponse,
  DeletePlaybackConfigurationResponse,
  ListPlaybackConfigurationsResponse,
  ConfigureLogsForChannelResponse,
  ListTagsForResourceResponse,
  SourceLocation,
  UntagResourceResponse,
  ListPrefetchSchedulesResponse,
  DeleteVodSourceResponse,
  DescribeVodSourceResponse,
  CreateProgramResponse,
  DeleteChannelPolicyResponse,
  PrefetchSchedule,
  DescribeLiveSourceResponse,
  UpdateLiveSourceResponse,
  PlaybackConfiguration,
  StartChannelResponse,
  DeleteProgramResponse,
  GetChannelScheduleResponse,
  GetPrefetchScheduleResponse,
  UpdateSourceLocationResponse,
  PutChannelPolicyResponse,
  CreateVodSourceResponse,
  Channel,
  LiveSource,
  TagResourceResponse,
  DeleteChannelResponse,
  ListVodSourcesResponse,
  ListSourceLocationsResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.mediatailor.{
  MediaTailorAsyncClientBuilder,
  MediaTailorAsyncClient
}
import scala.jdk.CollectionConverters.*
trait MediaTailor extends AspectSupport[MediaTailor] {
  val api: MediaTailorAsyncClient
  def putChannelPolicy(
      request: PutChannelPolicyRequest
  ): IO[AwsError, zio.aws.mediatailor.model.PutChannelPolicyResponse.ReadOnly]
  def createSourceLocation(request: CreateSourceLocationRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly
  ]
  def getChannelSchedule(
      request: GetChannelScheduleRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.ScheduleEntry.ReadOnly]
  def getChannelSchedulePaginated(
      request: GetChannelScheduleRequest
  ): IO[AwsError, zio.aws.mediatailor.model.GetChannelScheduleResponse.ReadOnly]
  def updateProgram(
      request: UpdateProgramRequest
  ): IO[AwsError, zio.aws.mediatailor.model.UpdateProgramResponse.ReadOnly]
  def createVodSource(
      request: CreateVodSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly]
  def listChannels(
      request: ListChannelsRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.Channel.ReadOnly]
  def listChannelsPaginated(
      request: ListChannelsRequest
  ): IO[AwsError, zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly]
  def getChannelPolicy(
      request: GetChannelPolicyRequest
  ): IO[AwsError, zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly]
  def createProgram(
      request: CreateProgramRequest
  ): IO[AwsError, zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly]
  def describeProgram(
      request: DescribeProgramRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly]
  def listSourceLocations(
      request: ListSourceLocationsRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.SourceLocation.ReadOnly]
  def listSourceLocationsPaginated(request: ListSourceLocationsRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.ListSourceLocationsResponse.ReadOnly
  ]
  def createPrefetchSchedule(request: CreatePrefetchScheduleRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly
  ]
  def createLiveSource(
      request: CreateLiveSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.CreateLiveSourceResponse.ReadOnly]
  def deleteChannel(
      request: DeleteChannelRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DeleteChannelResponse.ReadOnly]
  def configureLogsForPlaybackConfiguration(
      request: ConfigureLogsForPlaybackConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly
  ]
  def getPrefetchSchedule(
      request: GetPrefetchScheduleRequest
  ): IO[AwsError, ReadOnly]
  def getPlaybackConfiguration(request: GetPlaybackConfigurationRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly
  ]
  def configureLogsForChannel(request: ConfigureLogsForChannelRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.ReadOnly
  ]
  def updateVodSource(
      request: UpdateVodSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.UpdateVodSourceResponse.ReadOnly]
  def startChannel(
      request: StartChannelRequest
  ): IO[AwsError, zio.aws.mediatailor.model.StartChannelResponse.ReadOnly]
  def deleteLiveSource(
      request: DeleteLiveSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DeleteLiveSourceResponse.ReadOnly]
  def deleteSourceLocation(request: DeleteSourceLocationRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.DeleteSourceLocationResponse.ReadOnly
  ]
  def createChannel(
      request: CreateChannelRequest
  ): IO[AwsError, zio.aws.mediatailor.model.CreateChannelResponse.ReadOnly]
  def deletePrefetchSchedule(request: DeletePrefetchScheduleRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.DeletePrefetchScheduleResponse.ReadOnly
  ]
  def deletePlaybackConfiguration(
      request: DeletePlaybackConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mediatailor.model.DeletePlaybackConfigurationResponse.ReadOnly
  ]
  def updateSourceLocation(request: UpdateSourceLocationRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def listLiveSources(
      request: ListLiveSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.LiveSource.ReadOnly]
  def listLiveSourcesPaginated(
      request: ListLiveSourcesRequest
  ): IO[AwsError, zio.aws.mediatailor.model.ListLiveSourcesResponse.ReadOnly]
  def stopChannel(
      request: StopChannelRequest
  ): IO[AwsError, zio.aws.mediatailor.model.StopChannelResponse.ReadOnly]
  def deleteVodSource(
      request: DeleteVodSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DeleteVodSourceResponse.ReadOnly]
  def deleteProgram(
      request: DeleteProgramRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DeleteProgramResponse.ReadOnly]
  def listAlerts(
      request: ListAlertsRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.Alert.ReadOnly]
  def listAlertsPaginated(
      request: ListAlertsRequest
  ): IO[AwsError, zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def describeChannel(
      request: DescribeChannelRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DescribeChannelResponse.ReadOnly]
  def listPrefetchSchedules(
      request: ListPrefetchSchedulesRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly]
  def listPrefetchSchedulesPaginated(request: ListPrefetchSchedulesRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly
  ]
  def putPlaybackConfiguration(request: PutPlaybackConfigurationRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.PutPlaybackConfigurationResponse.ReadOnly
  ]
  def updateLiveSource(
      request: UpdateLiveSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.UpdateLiveSourceResponse.ReadOnly]
  def describeSourceLocation(request: DescribeSourceLocationRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly
  ]
  def describeLiveSource(
      request: DescribeLiveSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DescribeLiveSourceResponse.ReadOnly]
  def listVodSources(
      request: ListVodSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.mediatailor.model.VodSource.ReadOnly]
  def listVodSourcesPaginated(
      request: ListVodSourcesRequest
  ): IO[AwsError, zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly]
  def describeVodSource(
      request: DescribeVodSourceRequest
  ): IO[AwsError, zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly]
  def listPlaybackConfigurations(
      request: ListPlaybackConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
  ]
  def listPlaybackConfigurationsPaginated(
      request: ListPlaybackConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly
  ]
  def updateChannel(
      request: UpdateChannelRequest
  ): IO[AwsError, zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly]
  def deleteChannelPolicy(request: DeleteChannelPolicyRequest): IO[
    AwsError,
    zio.aws.mediatailor.model.DeleteChannelPolicyResponse.ReadOnly
  ]
}
object MediaTailor {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaTailor] = customized(
    identity
  )
  def customized(
      customization: MediaTailorAsyncClientBuilder => MediaTailorAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaTailor] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MediaTailorAsyncClientBuilder => MediaTailorAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MediaTailor] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MediaTailorAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaTailorAsyncClient, MediaTailorAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      MediaTailorAsyncClient,
      MediaTailorAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new MediaTailorImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MediaTailorImpl[R](
      override val api: MediaTailorAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaTailor
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaTailor"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaTailorImpl[R1] = new MediaTailorImpl(api, newAspect, r)
    def putChannelPolicy(request: PutChannelPolicyRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.PutChannelPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.PutChannelPolicyRequest,
      PutChannelPolicyResponse
    ]("putChannelPolicy", api.putChannelPolicy)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.PutChannelPolicyResponse.wrap)
      .provideEnvironment(r)
    def createSourceLocation(request: CreateSourceLocationRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest,
      CreateSourceLocationResponse
    ]("createSourceLocation", api.createSourceLocation)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.CreateSourceLocationResponse.wrap)
      .provideEnvironment(r)
    def getChannelSchedule(request: GetChannelScheduleRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediatailor.model.ScheduleEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest,
      GetChannelScheduleResponse,
      ScheduleEntry
    ](
      "getChannelSchedule",
      api.getChannelSchedule,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediatailor.model.ScheduleEntry.wrap(item))
      .provideEnvironment(r)
    def getChannelSchedulePaginated(request: GetChannelScheduleRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.GetChannelScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest,
      GetChannelScheduleResponse
    ]("getChannelSchedule", api.getChannelSchedule)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.GetChannelScheduleResponse.wrap)
      .provideEnvironment(r)
    def updateProgram(
        request: UpdateProgramRequest
    ): IO[AwsError, zio.aws.mediatailor.model.UpdateProgramResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest,
        UpdateProgramResponse
      ]("updateProgram", api.updateProgram)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.UpdateProgramResponse.wrap)
        .provideEnvironment(r)
    def createVodSource(request: CreateVodSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest,
      CreateVodSourceResponse
    ]("createVodSource", api.createVodSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.CreateVodSourceResponse.wrap)
      .provideEnvironment(r)
    def listChannels(
        request: ListChannelsRequest
    ): ZStream[Any, AwsError, zio.aws.mediatailor.model.Channel.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest,
        ListChannelsResponse,
        Channel
      ](
        "listChannels",
        api.listChannels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.mediatailor.model.Channel.wrap(item))
        .provideEnvironment(r)
    def listChannelsPaginated(
        request: ListChannelsRequest
    ): IO[AwsError, zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest,
        ListChannelsResponse
      ]("listChannels", api.listChannels)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.ListChannelsResponse.wrap)
        .provideEnvironment(r)
    def getChannelPolicy(request: GetChannelPolicyRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyRequest,
      GetChannelPolicyResponse
    ]("getChannelPolicy", api.getChannelPolicy)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.GetChannelPolicyResponse.wrap)
      .provideEnvironment(r)
    def createProgram(
        request: CreateProgramRequest
    ): IO[AwsError, zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest,
        CreateProgramResponse
      ]("createProgram", api.createProgram)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.CreateProgramResponse.wrap)
        .provideEnvironment(r)
    def describeProgram(request: DescribeProgramRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DescribeProgramRequest,
      DescribeProgramResponse
    ]("describeProgram", api.describeProgram)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DescribeProgramResponse.wrap)
      .provideEnvironment(r)
    def listSourceLocations(request: ListSourceLocationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediatailor.model.SourceLocation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest,
      ListSourceLocationsResponse,
      SourceLocation
    ](
      "listSourceLocations",
      api.listSourceLocations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediatailor.model.SourceLocation.wrap(item))
      .provideEnvironment(r)
    def listSourceLocationsPaginated(request: ListSourceLocationsRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.ListSourceLocationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest,
      ListSourceLocationsResponse
    ]("listSourceLocations", api.listSourceLocations)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.ListSourceLocationsResponse.wrap)
      .provideEnvironment(r)
    def createPrefetchSchedule(request: CreatePrefetchScheduleRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest,
      CreatePrefetchScheduleResponse
    ]("createPrefetchSchedule", api.createPrefetchSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.wrap)
      .provideEnvironment(r)
    def createLiveSource(request: CreateLiveSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.CreateLiveSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest,
      CreateLiveSourceResponse
    ]("createLiveSource", api.createLiveSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.CreateLiveSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteChannel(
        request: DeleteChannelRequest
    ): IO[AwsError, zio.aws.mediatailor.model.DeleteChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.DeleteChannelRequest,
        DeleteChannelResponse
      ]("deleteChannel", api.deleteChannel)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.DeleteChannelResponse.wrap)
        .provideEnvironment(r)
    def configureLogsForPlaybackConfiguration(
        request: ConfigureLogsForPlaybackConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest,
      ConfigureLogsForPlaybackConfigurationResponse
    ](
      "configureLogsForPlaybackConfiguration",
      api.configureLogsForPlaybackConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getPrefetchSchedule(
        request: GetPrefetchScheduleRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleRequest,
      GetPrefetchScheduleResponse
    ]("getPrefetchSchedule", api.getPrefetchSchedule)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.GetPrefetchScheduleResponse.wrap)
      .provideEnvironment(r)
    def getPlaybackConfiguration(request: GetPlaybackConfigurationRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationRequest,
      GetPlaybackConfigurationResponse
    ]("getPlaybackConfiguration", api.getPlaybackConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.wrap)
      .provideEnvironment(r)
    def configureLogsForChannel(request: ConfigureLogsForChannelRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest,
      ConfigureLogsForChannelResponse
    ]("configureLogsForChannel", api.configureLogsForChannel)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.wrap)
      .provideEnvironment(r)
    def updateVodSource(request: UpdateVodSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.UpdateVodSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest,
      UpdateVodSourceResponse
    ]("updateVodSource", api.updateVodSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.UpdateVodSourceResponse.wrap)
      .provideEnvironment(r)
    def startChannel(
        request: StartChannelRequest
    ): IO[AwsError, zio.aws.mediatailor.model.StartChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.StartChannelRequest,
        StartChannelResponse
      ]("startChannel", api.startChannel)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.StartChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteLiveSource(request: DeleteLiveSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DeleteLiveSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DeleteLiveSourceRequest,
      DeleteLiveSourceResponse
    ]("deleteLiveSource", api.deleteLiveSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DeleteLiveSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteSourceLocation(request: DeleteSourceLocationRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DeleteSourceLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DeleteSourceLocationRequest,
      DeleteSourceLocationResponse
    ]("deleteSourceLocation", api.deleteSourceLocation)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DeleteSourceLocationResponse.wrap)
      .provideEnvironment(r)
    def createChannel(
        request: CreateChannelRequest
    ): IO[AwsError, zio.aws.mediatailor.model.CreateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest,
        CreateChannelResponse
      ]("createChannel", api.createChannel)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.CreateChannelResponse.wrap)
        .provideEnvironment(r)
    def deletePrefetchSchedule(request: DeletePrefetchScheduleRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DeletePrefetchScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DeletePrefetchScheduleRequest,
      DeletePrefetchScheduleResponse
    ]("deletePrefetchSchedule", api.deletePrefetchSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.DeletePrefetchScheduleResponse.wrap)
      .provideEnvironment(r)
    def deletePlaybackConfiguration(
        request: DeletePlaybackConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mediatailor.model.DeletePlaybackConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DeletePlaybackConfigurationRequest,
      DeletePlaybackConfigurationResponse
    ]("deletePlaybackConfiguration", api.deletePlaybackConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.DeletePlaybackConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateSourceLocation(request: UpdateSourceLocationRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationRequest,
      UpdateSourceLocationResponse
    ]("updateSourceLocation", api.updateSourceLocation)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.UpdateSourceLocationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listLiveSources(request: ListLiveSourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediatailor.model.LiveSource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest,
      ListLiveSourcesResponse,
      LiveSource
    ](
      "listLiveSources",
      api.listLiveSources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediatailor.model.LiveSource.wrap(item))
      .provideEnvironment(r)
    def listLiveSourcesPaginated(request: ListLiveSourcesRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.ListLiveSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest,
      ListLiveSourcesResponse
    ]("listLiveSources", api.listLiveSources)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.ListLiveSourcesResponse.wrap)
      .provideEnvironment(r)
    def stopChannel(
        request: StopChannelRequest
    ): IO[AwsError, zio.aws.mediatailor.model.StopChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.StopChannelRequest,
        StopChannelResponse
      ]("stopChannel", api.stopChannel)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.StopChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteVodSource(request: DeleteVodSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DeleteVodSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DeleteVodSourceRequest,
      DeleteVodSourceResponse
    ]("deleteVodSource", api.deleteVodSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DeleteVodSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteProgram(
        request: DeleteProgramRequest
    ): IO[AwsError, zio.aws.mediatailor.model.DeleteProgramResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.DeleteProgramRequest,
        DeleteProgramResponse
      ]("deleteProgram", api.deleteProgram)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.DeleteProgramResponse.wrap)
        .provideEnvironment(r)
    def listAlerts(
        request: ListAlertsRequest
    ): ZStream[Any, AwsError, zio.aws.mediatailor.model.Alert.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest,
        ListAlertsResponse,
        Alert
      ](
        "listAlerts",
        api.listAlerts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.mediatailor.model.Alert.wrap(item))
        .provideEnvironment(r)
    def listAlertsPaginated(
        request: ListAlertsRequest
    ): IO[AwsError, zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest,
        ListAlertsResponse
      ]("listAlerts", api.listAlerts)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.ListAlertsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeChannel(request: DescribeChannelRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DescribeChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DescribeChannelRequest,
      DescribeChannelResponse
    ]("describeChannel", api.describeChannel)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DescribeChannelResponse.wrap)
      .provideEnvironment(r)
    def listPrefetchSchedules(request: ListPrefetchSchedulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest,
      ListPrefetchSchedulesResponse,
      PrefetchSchedule
    ](
      "listPrefetchSchedules",
      api.listPrefetchSchedules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediatailor.model.PrefetchSchedule.wrap(item))
      .provideEnvironment(r)
    def listPrefetchSchedulesPaginated(
        request: ListPrefetchSchedulesRequest
    ): IO[
      AwsError,
      zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest,
      ListPrefetchSchedulesResponse
    ]("listPrefetchSchedules", api.listPrefetchSchedules)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.wrap)
      .provideEnvironment(r)
    def putPlaybackConfiguration(request: PutPlaybackConfigurationRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.PutPlaybackConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest,
      PutPlaybackConfigurationResponse
    ]("putPlaybackConfiguration", api.putPlaybackConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.PutPlaybackConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateLiveSource(request: UpdateLiveSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.UpdateLiveSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest,
      UpdateLiveSourceResponse
    ]("updateLiveSource", api.updateLiveSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.UpdateLiveSourceResponse.wrap)
      .provideEnvironment(r)
    def describeSourceLocation(request: DescribeSourceLocationRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationRequest,
      DescribeSourceLocationResponse
    ]("describeSourceLocation", api.describeSourceLocation)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.DescribeSourceLocationResponse.wrap)
      .provideEnvironment(r)
    def describeLiveSource(request: DescribeLiveSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DescribeLiveSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DescribeLiveSourceRequest,
      DescribeLiveSourceResponse
    ]("describeLiveSource", api.describeLiveSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DescribeLiveSourceResponse.wrap)
      .provideEnvironment(r)
    def listVodSources(
        request: ListVodSourcesRequest
    ): ZStream[Any, AwsError, zio.aws.mediatailor.model.VodSource.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest,
        ListVodSourcesResponse,
        VodSource
      ](
        "listVodSources",
        api.listVodSources,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.mediatailor.model.VodSource.wrap(item))
        .provideEnvironment(r)
    def listVodSourcesPaginated(
        request: ListVodSourcesRequest
    ): IO[AwsError, zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest,
        ListVodSourcesResponse
      ]("listVodSources", api.listVodSources)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.ListVodSourcesResponse.wrap)
        .provideEnvironment(r)
    def describeVodSource(request: DescribeVodSourceRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceRequest,
      DescribeVodSourceResponse
    ]("describeVodSource", api.describeVodSource)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DescribeVodSourceResponse.wrap)
      .provideEnvironment(r)
    def listPlaybackConfigurations(
        request: ListPlaybackConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest,
      ListPlaybackConfigurationsResponse,
      PlaybackConfiguration
    ](
      "listPlaybackConfigurations",
      api.listPlaybackConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediatailor.model.PlaybackConfiguration.wrap(item))
      .provideEnvironment(r)
    def listPlaybackConfigurationsPaginated(
        request: ListPlaybackConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest,
      ListPlaybackConfigurationsResponse
    ]("listPlaybackConfigurations", api.listPlaybackConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def updateChannel(
        request: UpdateChannelRequest
    ): IO[AwsError, zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest,
        UpdateChannelResponse
      ]("updateChannel", api.updateChannel)(request.buildAwsValue())
        .map(zio.aws.mediatailor.model.UpdateChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteChannelPolicy(request: DeleteChannelPolicyRequest): IO[
      AwsError,
      zio.aws.mediatailor.model.DeleteChannelPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediatailor.model.DeleteChannelPolicyRequest,
      DeleteChannelPolicyResponse
    ]("deleteChannelPolicy", api.deleteChannelPolicy)(request.buildAwsValue())
      .map(zio.aws.mediatailor.model.DeleteChannelPolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def putChannelPolicy(request: PutChannelPolicyRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.PutChannelPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putChannelPolicy(request))
  def createSourceLocation(request: CreateSourceLocationRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSourceLocation(request))
  def getChannelSchedule(request: GetChannelScheduleRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ScheduleEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.getChannelSchedule(request))
  def getChannelSchedulePaginated(request: GetChannelScheduleRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.GetChannelScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelSchedulePaginated(request))
  def updateProgram(request: UpdateProgramRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.UpdateProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProgram(request))
  def createVodSource(request: CreateVodSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVodSource(request))
  def listChannels(request: ListChannelsRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.Channel.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannels(request))
  def listChannelsPaginated(request: ListChannelsRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelsPaginated(request))
  def getChannelPolicy(request: GetChannelPolicyRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelPolicy(request))
  def createProgram(request: CreateProgramRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProgram(request))
  def describeProgram(request: DescribeProgramRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProgram(request))
  def listSourceLocations(request: ListSourceLocationsRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.SourceLocation.ReadOnly
  ] = ZStream.serviceWithStream(_.listSourceLocations(request))
  def listSourceLocationsPaginated(request: ListSourceLocationsRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListSourceLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSourceLocationsPaginated(request))
  def createPrefetchSchedule(request: CreatePrefetchScheduleRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPrefetchSchedule(request))
  def createLiveSource(request: CreateLiveSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.CreateLiveSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLiveSource(request))
  def deleteChannel(request: DeleteChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeleteChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannel(request))
  def configureLogsForPlaybackConfiguration(
      request: ConfigureLogsForPlaybackConfigurationRequest
  ): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureLogsForPlaybackConfiguration(request))
  def getPrefetchSchedule(
      request: GetPrefetchScheduleRequest
  ): ZIO[zio.aws.mediatailor.MediaTailor, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getPrefetchSchedule(request))
  def getPlaybackConfiguration(request: GetPlaybackConfigurationRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPlaybackConfiguration(request))
  def configureLogsForChannel(request: ConfigureLogsForChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ConfigureLogsForChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureLogsForChannel(request))
  def updateVodSource(request: UpdateVodSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.UpdateVodSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVodSource(request))
  def startChannel(request: StartChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.StartChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startChannel(request))
  def deleteLiveSource(request: DeleteLiveSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeleteLiveSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLiveSource(request))
  def deleteSourceLocation(request: DeleteSourceLocationRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeleteSourceLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSourceLocation(request))
  def createChannel(request: CreateChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def deletePrefetchSchedule(request: DeletePrefetchScheduleRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeletePrefetchScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePrefetchSchedule(request))
  def deletePlaybackConfiguration(
      request: DeletePlaybackConfigurationRequest
  ): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeletePlaybackConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePlaybackConfiguration(request))
  def updateSourceLocation(request: UpdateSourceLocationRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSourceLocation(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.mediatailor.MediaTailor, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def listLiveSources(request: ListLiveSourcesRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.LiveSource.ReadOnly
  ] = ZStream.serviceWithStream(_.listLiveSources(request))
  def listLiveSourcesPaginated(request: ListLiveSourcesRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListLiveSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLiveSourcesPaginated(request))
  def stopChannel(request: StopChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.StopChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopChannel(request))
  def deleteVodSource(request: DeleteVodSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeleteVodSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVodSource(request))
  def deleteProgram(request: DeleteProgramRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeleteProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProgram(request))
  def listAlerts(request: ListAlertsRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.Alert.ReadOnly
  ] = ZStream.serviceWithStream(_.listAlerts(request))
  def listAlertsPaginated(request: ListAlertsRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAlertsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.mediatailor.MediaTailor, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def describeChannel(request: DescribeChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DescribeChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannel(request))
  def listPrefetchSchedules(request: ListPrefetchSchedulesRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly
  ] = ZStream.serviceWithStream(_.listPrefetchSchedules(request))
  def listPrefetchSchedulesPaginated(
      request: ListPrefetchSchedulesRequest
  ): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPrefetchSchedulesPaginated(request))
  def putPlaybackConfiguration(request: PutPlaybackConfigurationRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.PutPlaybackConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putPlaybackConfiguration(request))
  def updateLiveSource(request: UpdateLiveSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.UpdateLiveSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLiveSource(request))
  def describeSourceLocation(request: DescribeSourceLocationRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSourceLocation(request))
  def describeLiveSource(request: DescribeLiveSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DescribeLiveSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLiveSource(request))
  def listVodSources(request: ListVodSourcesRequest): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.VodSource.ReadOnly
  ] = ZStream.serviceWithStream(_.listVodSources(request))
  def listVodSourcesPaginated(request: ListVodSourcesRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVodSourcesPaginated(request))
  def describeVodSource(request: DescribeVodSourceRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVodSource(request))
  def listPlaybackConfigurations(
      request: ListPlaybackConfigurationsRequest
  ): ZStream[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlaybackConfigurations(request))
  def listPlaybackConfigurationsPaginated(
      request: ListPlaybackConfigurationsRequest
  ): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlaybackConfigurationsPaginated(request))
  def updateChannel(request: UpdateChannelRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
  def deleteChannelPolicy(request: DeleteChannelPolicyRequest): ZIO[
    zio.aws.mediatailor.MediaTailor,
    AwsError,
    zio.aws.mediatailor.model.DeleteChannelPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannelPolicy(request))
}
