package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class UpdateChannelResponse(
    arn: Optional[__string] = Optional.Absent,
    channelName: Optional[__string] = Optional.Absent,
    channelState: Optional[zio.aws.mediatailor.model.ChannelState] =
      Optional.Absent,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    fillerSlate: Optional[zio.aws.mediatailor.model.SlateSource] =
      Optional.Absent,
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.mediatailor.model.ResponseOutputItem]] =
      Optional.Absent,
    playbackMode: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    tier: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(channelName.map(value => value: java.lang.String))(
        _.channelName
      )
      .optionallyWith(channelState.map(value => value.unwrap))(_.channelState)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(fillerSlate.map(value => value.buildAwsValue()))(
        _.fillerSlate
      )
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(playbackMode.map(value => value: java.lang.String))(
        _.playbackMode
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(tier.map(value => value: java.lang.String))(_.tier)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly =
    zio.aws.mediatailor.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateChannelResponse =
      zio.aws.mediatailor.model.UpdateChannelResponse(
        arn.map(value => value),
        channelName.map(value => value),
        channelState.map(value => value),
        creationTime.map(value => value),
        fillerSlate.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        playbackMode.map(value => value),
        tags.map(value => value),
        tier.map(value => value)
      )
    def arn: Optional[__string]
    def channelName: Optional[__string]
    def channelState: Optional[zio.aws.mediatailor.model.ChannelState]
    def creationTime: Optional[__timestampUnix]
    def fillerSlate: Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def lastModifiedTime: Optional[__timestampUnix]
    def outputs
        : Optional[List[zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly]]
    def playbackMode: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def tier: Optional[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelState
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.ChannelState] =
      AwsError.unwrapOptionField("channelState", channelState)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFillerSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("fillerSlate", fillerSlate)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getPlaybackMode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("playbackMode", playbackMode)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("tier", tier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
  ) extends zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val channelName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => value: __string)
    override val channelState
        : Optional[zio.aws.mediatailor.model.ChannelState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelState())
        .map(value => zio.aws.mediatailor.model.ChannelState.wrap(value))
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val fillerSlate
        : Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fillerSlate())
        .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val outputs: Optional[
      List[zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.ResponseOutputItem.wrap(item)
        }.toList
      )
    override val playbackMode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.playbackMode())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val tier: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.tier())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
  ): zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
