package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SlateSource(
    sourceLocationName: Optional[__string] = Optional.Absent,
    vodSourceName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SlateSource = {
    import SlateSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SlateSource
      .builder()
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(vodSourceName.map(value => value: java.lang.String))(
        _.vodSourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.SlateSource.ReadOnly =
    zio.aws.mediatailor.model.SlateSource.wrap(buildAwsValue())
}
object SlateSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SlateSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SlateSource =
      zio.aws.mediatailor.model.SlateSource(
        sourceLocationName.map(value => value),
        vodSourceName.map(value => value)
      )
    def sourceLocationName: Optional[__string]
    def vodSourceName: Optional[__string]
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SlateSource
  ) extends zio.aws.mediatailor.model.SlateSource.ReadOnly {
    override val sourceLocationName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceLocationName())
      .map(value => value: __string)
    override val vodSourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vodSourceName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SlateSource
  ): zio.aws.mediatailor.model.SlateSource.ReadOnly = new Wrapper(impl)
}
