package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SegmentDeliveryConfiguration(
    baseUrl: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration = {
    import SegmentDeliveryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration
      .builder()
      .optionallyWith(baseUrl.map(value => value: java.lang.String))(_.baseUrl)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly =
    zio.aws.mediatailor.model.SegmentDeliveryConfiguration.wrap(buildAwsValue())
}
object SegmentDeliveryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SegmentDeliveryConfiguration =
      zio.aws.mediatailor.model.SegmentDeliveryConfiguration(
        baseUrl.map(value => value),
        name.map(value => value)
      )
    def baseUrl: Optional[__string]
    def name: Optional[__string]
    def getBaseUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("baseUrl", baseUrl)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration
  ) extends zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly {
    override val baseUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.baseUrl())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration
  ): zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly =
    new Wrapper(impl)
}
