package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateChannelRequest(
    channelName: __string,
    fillerSlate: Optional[zio.aws.mediatailor.model.SlateSource] =
      Optional.Absent,
    outputs: Iterable[zio.aws.mediatailor.model.RequestOutputItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
      .builder()
      .channelName(channelName: java.lang.String)
      .optionallyWith(fillerSlate.map(value => value.buildAwsValue()))(
        _.fillerSlate
      )
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateChannelRequest.ReadOnly =
    zio.aws.mediatailor.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateChannelRequest =
      zio.aws.mediatailor.model.UpdateChannelRequest(
        channelName,
        fillerSlate.map(value => value.asEditable),
        outputs.map { item =>
          item.asEditable
        }
      )
    def channelName: __string
    def fillerSlate: Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def outputs: List[zio.aws.mediatailor.model.RequestOutputItem.ReadOnly]
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getFillerSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("fillerSlate", fillerSlate)
    def getOutputs: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.RequestOutputItem.ReadOnly
    ]] = ZIO.succeed(outputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
  ) extends zio.aws.mediatailor.model.UpdateChannelRequest.ReadOnly {
    override val channelName: __string = impl.channelName(): __string
    override val fillerSlate
        : Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fillerSlate())
        .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val outputs
        : List[zio.aws.mediatailor.model.RequestOutputItem.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.mediatailor.model.RequestOutputItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
  ): zio.aws.mediatailor.model.UpdateChannelRequest.ReadOnly = new Wrapper(impl)
}
