package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait Operator {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.Operator
}
object Operator {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.Operator
  ): zio.aws.mediatailor.model.Operator = value match {
    case software.amazon.awssdk.services.mediatailor.model.Operator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.Operator.EQUALS =>
      val r = EQUALS
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Operator =
      software.amazon.awssdk.services.mediatailor.model.Operator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.mediatailor.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Operator =
      software.amazon.awssdk.services.mediatailor.model.Operator.EQUALS
  }
}
