package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVodSourcesResponse(
    items: Optional[Iterable[zio.aws.mediatailor.model.VodSource]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse = {
    import ListVodSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly =
    zio.aws.mediatailor.model.ListVodSourcesResponse.wrap(buildAwsValue())
}
object ListVodSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListVodSourcesResponse =
      zio.aws.mediatailor.model.ListVodSourcesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mediatailor.model.VodSource.ReadOnly]]
    def nextToken: Optional[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.VodSource.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse
  ) extends zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mediatailor.model.VodSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.VodSource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse
  ): zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
