package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{MaxResults, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetChannelScheduleRequest(
    channelName: __string,
    durationMinutes: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest = {
    import GetChannelScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
      .builder()
      .channelName(channelName: java.lang.String)
      .optionallyWith(durationMinutes.map(value => value: java.lang.String))(
        _.durationMinutes
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.GetChannelScheduleRequest.ReadOnly =
    zio.aws.mediatailor.model.GetChannelScheduleRequest.wrap(buildAwsValue())
}
object GetChannelScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.GetChannelScheduleRequest =
      zio.aws.mediatailor.model.GetChannelScheduleRequest(
        channelName,
        durationMinutes.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelName: __string
    def durationMinutes: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getDurationMinutes: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("durationMinutes", durationMinutes)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
  ) extends zio.aws.mediatailor.model.GetChannelScheduleRequest.ReadOnly {
    override val channelName: __string = impl.channelName(): __string
    override val durationMinutes: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMinutes())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mediatailor.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
  ): zio.aws.mediatailor.model.GetChannelScheduleRequest.ReadOnly = new Wrapper(
    impl
  )
}
