package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLiveSourceRequest(
    httpPackageConfigurations: Iterable[
      zio.aws.mediatailor.model.HttpPackageConfiguration
    ],
    liveSourceName: __string,
    sourceLocationName: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest = {
    import CreateLiveSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest
      .builder()
      .httpPackageConfigurations(httpPackageConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .liveSourceName(liveSourceName: java.lang.String)
      .sourceLocationName(sourceLocationName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateLiveSourceRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateLiveSourceRequest.wrap(buildAwsValue())
}
object CreateLiveSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateLiveSourceRequest =
      zio.aws.mediatailor.model.CreateLiveSourceRequest(
        httpPackageConfigurations.map { item =>
          item.asEditable
        },
        liveSourceName,
        sourceLocationName,
        tags.map(value => value)
      )
    def httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    def liveSourceName: __string
    def sourceLocationName: __string
    def tags: Optional[Map[__string, __string]]
    def getHttpPackageConfigurations: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = ZIO.succeed(httpPackageConfigurations)
    def getLiveSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(liveSourceName)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest
  ) extends zio.aws.mediatailor.model.CreateLiveSourceRequest.ReadOnly {
    override val httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly] =
      impl
        .httpPackageConfigurations()
        .asScala
        .map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }
        .toList
    override val liveSourceName: __string = impl.liveSourceName(): __string
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest
  ): zio.aws.mediatailor.model.CreateLiveSourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
