package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPrefetchSchedulesResponse(
    items: Optional[Iterable[zio.aws.mediatailor.model.PrefetchSchedule]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse = {
    import ListPrefetchSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly =
    zio.aws.mediatailor.model.ListPrefetchSchedulesResponse
      .wrap(buildAwsValue())
}
object ListPrefetchSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListPrefetchSchedulesResponse =
      zio.aws.mediatailor.model.ListPrefetchSchedulesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items
        : Optional[List[zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly]]
    def nextToken: Optional[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
  ) extends zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.PrefetchSchedule.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
  ): zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly =
    new Wrapper(impl)
}
