package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecretsManagerAccessTokenConfiguration(
    headerName: Optional[__string] = Optional.Absent,
    secretArn: Optional[__string] = Optional.Absent,
    secretStringKey: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SecretsManagerAccessTokenConfiguration = {
    import SecretsManagerAccessTokenConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SecretsManagerAccessTokenConfiguration
      .builder()
      .optionallyWith(headerName.map(value => value: java.lang.String))(
        _.headerName
      )
      .optionallyWith(secretArn.map(value => value: java.lang.String))(
        _.secretArn
      )
      .optionallyWith(secretStringKey.map(value => value: java.lang.String))(
        _.secretStringKey
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration.ReadOnly =
    zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration
      .wrap(buildAwsValue())
}
object SecretsManagerAccessTokenConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SecretsManagerAccessTokenConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration =
      zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration(
        headerName.map(value => value),
        secretArn.map(value => value),
        secretStringKey.map(value => value)
      )
    def headerName: Optional[__string]
    def secretArn: Optional[__string]
    def secretStringKey: Optional[__string]
    def getHeaderName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("headerName", headerName)
    def getSecretArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getSecretStringKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("secretStringKey", secretStringKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SecretsManagerAccessTokenConfiguration
  ) extends zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration.ReadOnly {
    override val headerName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.headerName())
      .map(value => value: __string)
    override val secretArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => value: __string)
    override val secretStringKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.secretStringKey())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SecretsManagerAccessTokenConfiguration
  ): zio.aws.mediatailor.model.SecretsManagerAccessTokenConfiguration.ReadOnly =
    new Wrapper(impl)
}
