package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__string, __integer}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ConfigureLogsForPlaybackConfigurationResponse(
    percentEnabled: Optional[__integer] = Optional.Absent,
    playbackConfigurationName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse = {
    import ConfigureLogsForPlaybackConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
      .builder()
      .optionallyWith(percentEnabled.map(value => value: Integer))(
        _.percentEnabled
      )
      .optionallyWith(
        playbackConfigurationName.map(value => value: java.lang.String)
      )(_.playbackConfigurationName)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly =
    zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
      .wrap(buildAwsValue())
}
object ConfigureLogsForPlaybackConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse =
      zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse(
        percentEnabled.map(value => value),
        playbackConfigurationName.map(value => value)
      )
    def percentEnabled: Optional[__integer]
    def playbackConfigurationName: Optional[__string]
    def getPercentEnabled: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("percentEnabled", percentEnabled)
    def getPlaybackConfigurationName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("playbackConfigurationName", playbackConfigurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
  ) extends zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly {
    override val percentEnabled: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentEnabled())
      .map(value => value: __integer)
    override val playbackConfigurationName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playbackConfigurationName())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
  ): zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
