package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__integerMin1, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PutPlaybackConfigurationRequest(
    adDecisionServerUrl: Optional[__string] = Optional.Absent,
    availSuppression: Optional[zio.aws.mediatailor.model.AvailSuppression] =
      Optional.Absent,
    bumper: Optional[zio.aws.mediatailor.model.Bumper] = Optional.Absent,
    cdnConfiguration: Optional[zio.aws.mediatailor.model.CdnConfiguration] =
      Optional.Absent,
    configurationAliases: Optional[Map[__string, Map[__string, __string]]] =
      Optional.Absent,
    dashConfiguration: Optional[
      zio.aws.mediatailor.model.DashConfigurationForPut
    ] = Optional.Absent,
    livePreRollConfiguration: Optional[
      zio.aws.mediatailor.model.LivePreRollConfiguration
    ] = Optional.Absent,
    manifestProcessingRules: Optional[
      zio.aws.mediatailor.model.ManifestProcessingRules
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    personalizationThresholdSeconds: Optional[__integerMin1] = Optional.Absent,
    slateAdUrl: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    transcodeProfileName: Optional[__string] = Optional.Absent,
    videoContentSourceUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest = {
    import PutPlaybackConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
      .builder()
      .optionallyWith(
        adDecisionServerUrl.map(value => value: java.lang.String)
      )(_.adDecisionServerUrl)
      .optionallyWith(availSuppression.map(value => value.buildAwsValue()))(
        _.availSuppression
      )
      .optionallyWith(bumper.map(value => value.buildAwsValue()))(_.bumper)
      .optionallyWith(cdnConfiguration.map(value => value.buildAwsValue()))(
        _.cdnConfiguration
      )
      .optionallyWith(
        configurationAliases.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (value: java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.configurationAliases)
      .optionallyWith(dashConfiguration.map(value => value.buildAwsValue()))(
        _.dashConfiguration
      )
      .optionallyWith(
        livePreRollConfiguration.map(value => value.buildAwsValue())
      )(_.livePreRollConfiguration)
      .optionallyWith(
        manifestProcessingRules.map(value => value.buildAwsValue())
      )(_.manifestProcessingRules)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        personalizationThresholdSeconds.map(value => value: Integer)
      )(_.personalizationThresholdSeconds)
      .optionallyWith(slateAdUrl.map(value => value: java.lang.String))(
        _.slateAdUrl
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        transcodeProfileName.map(value => value: java.lang.String)
      )(_.transcodeProfileName)
      .optionallyWith(
        videoContentSourceUrl.map(value => value: java.lang.String)
      )(_.videoContentSourceUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.PutPlaybackConfigurationRequest.ReadOnly =
    zio.aws.mediatailor.model.PutPlaybackConfigurationRequest
      .wrap(buildAwsValue())
}
object PutPlaybackConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.PutPlaybackConfigurationRequest =
      zio.aws.mediatailor.model.PutPlaybackConfigurationRequest(
        adDecisionServerUrl.map(value => value),
        availSuppression.map(value => value.asEditable),
        bumper.map(value => value.asEditable),
        cdnConfiguration.map(value => value.asEditable),
        configurationAliases.map(value => value),
        dashConfiguration.map(value => value.asEditable),
        livePreRollConfiguration.map(value => value.asEditable),
        manifestProcessingRules.map(value => value.asEditable),
        name.map(value => value),
        personalizationThresholdSeconds.map(value => value),
        slateAdUrl.map(value => value),
        tags.map(value => value),
        transcodeProfileName.map(value => value),
        videoContentSourceUrl.map(value => value)
      )
    def adDecisionServerUrl: Optional[__string]
    def availSuppression
        : Optional[zio.aws.mediatailor.model.AvailSuppression.ReadOnly]
    def bumper: Optional[zio.aws.mediatailor.model.Bumper.ReadOnly]
    def cdnConfiguration
        : Optional[zio.aws.mediatailor.model.CdnConfiguration.ReadOnly]
    def configurationAliases: Optional[Map[__string, Map[__string, __string]]]
    def dashConfiguration
        : Optional[zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly]
    def livePreRollConfiguration
        : Optional[zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly]
    def manifestProcessingRules
        : Optional[zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly]
    def name: Optional[__string]
    def personalizationThresholdSeconds: Optional[__integerMin1]
    def slateAdUrl: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def transcodeProfileName: Optional[__string]
    def videoContentSourceUrl: Optional[__string]
    def getAdDecisionServerUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("adDecisionServerUrl", adDecisionServerUrl)
    def getAvailSuppression: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AvailSuppression.ReadOnly
    ] = AwsError.unwrapOptionField("availSuppression", availSuppression)
    def getBumper
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.Bumper.ReadOnly] =
      AwsError.unwrapOptionField("bumper", bumper)
    def getCdnConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.CdnConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("cdnConfiguration", cdnConfiguration)
    def getConfigurationAliases
        : ZIO[Any, AwsError, Map[__string, Map[__string, __string]]] =
      AwsError.unwrapOptionField("configurationAliases", configurationAliases)
    def getDashConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly
    ] = AwsError.unwrapOptionField("dashConfiguration", dashConfiguration)
    def getLivePreRollConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "livePreRollConfiguration",
      livePreRollConfiguration
    )
    def getManifestProcessingRules: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly
    ] = AwsError.unwrapOptionField(
      "manifestProcessingRules",
      manifestProcessingRules
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPersonalizationThresholdSeconds: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField(
        "personalizationThresholdSeconds",
        personalizationThresholdSeconds
      )
    def getSlateAdUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("slateAdUrl", slateAdUrl)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTranscodeProfileName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("transcodeProfileName", transcodeProfileName)
    def getVideoContentSourceUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoContentSourceUrl", videoContentSourceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
  ) extends zio.aws.mediatailor.model.PutPlaybackConfigurationRequest.ReadOnly {
    override val adDecisionServerUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.adDecisionServerUrl())
      .map(value => value: __string)
    override val availSuppression
        : Optional[zio.aws.mediatailor.model.AvailSuppression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availSuppression())
        .map(value => zio.aws.mediatailor.model.AvailSuppression.wrap(value))
    override val bumper: Optional[zio.aws.mediatailor.model.Bumper.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bumper())
        .map(value => zio.aws.mediatailor.model.Bumper.wrap(value))
    override val cdnConfiguration
        : Optional[zio.aws.mediatailor.model.CdnConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdnConfiguration())
        .map(value => zio.aws.mediatailor.model.CdnConfiguration.wrap(value))
    override val configurationAliases
        : Optional[Map[__string, Map[__string, __string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationAliases())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala
                .map({ case (key, value) =>
                  (key: __string) -> (value: __string)
                })
                .toMap
            })
            .toMap
        )
    override val dashConfiguration
        : Optional[zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashConfiguration())
        .map(value =>
          zio.aws.mediatailor.model.DashConfigurationForPut.wrap(value)
        )
    override val livePreRollConfiguration: Optional[
      zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.livePreRollConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.LivePreRollConfiguration.wrap(value)
      )
    override val manifestProcessingRules
        : Optional[zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestProcessingRules())
        .map(value =>
          zio.aws.mediatailor.model.ManifestProcessingRules.wrap(value)
        )
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val personalizationThresholdSeconds: Optional[__integerMin1] =
      zio.aws.core.internal
        .optionalFromNullable(impl.personalizationThresholdSeconds())
        .map(value => value: __integerMin1)
    override val slateAdUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.slateAdUrl())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val transcodeProfileName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcodeProfileName())
        .map(value => value: __string)
    override val videoContentSourceUrl: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoContentSourceUrl())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
  ): zio.aws.mediatailor.model.PutPlaybackConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
