package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProgramRequest(
    adBreaks: Optional[Iterable[zio.aws.mediatailor.model.AdBreak]] =
      Optional.Absent,
    channelName: __string,
    liveSourceName: Optional[__string] = Optional.Absent,
    programName: __string,
    scheduleConfiguration: zio.aws.mediatailor.model.ScheduleConfiguration,
    sourceLocationName: __string,
    vodSourceName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest = {
    import CreateProgramRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
      .builder()
      .optionallyWith(
        adBreaks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adBreaks)
      .channelName(channelName: java.lang.String)
      .optionallyWith(liveSourceName.map(value => value: java.lang.String))(
        _.liveSourceName
      )
      .programName(programName: java.lang.String)
      .scheduleConfiguration(scheduleConfiguration.buildAwsValue())
      .sourceLocationName(sourceLocationName: java.lang.String)
      .optionallyWith(vodSourceName.map(value => value: java.lang.String))(
        _.vodSourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateProgramRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateProgramRequest.wrap(buildAwsValue())
}
object CreateProgramRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateProgramRequest =
      zio.aws.mediatailor.model.CreateProgramRequest(
        adBreaks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelName,
        liveSourceName.map(value => value),
        programName,
        scheduleConfiguration.asEditable,
        sourceLocationName,
        vodSourceName.map(value => value)
      )
    def adBreaks: Optional[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]]
    def channelName: __string
    def liveSourceName: Optional[__string]
    def programName: __string
    def scheduleConfiguration
        : zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly
    def sourceLocationName: __string
    def vodSourceName: Optional[__string]
    def getAdBreaks
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      AwsError.unwrapOptionField("adBreaks", adBreaks)
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getLiveSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("liveSourceName", liveSourceName)
    def getProgramName: ZIO[Any, Nothing, __string] = ZIO.succeed(programName)
    def getScheduleConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly
    ] = ZIO.succeed(scheduleConfiguration)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
  ) extends zio.aws.mediatailor.model.CreateProgramRequest.ReadOnly {
    override val adBreaks
        : Optional[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adBreaks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.AdBreak.wrap(item)
          }.toList
        )
    override val channelName: __string = impl.channelName(): __string
    override val liveSourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.liveSourceName())
      .map(value => value: __string)
    override val programName: __string = impl.programName(): __string
    override val scheduleConfiguration
        : zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly =
      zio.aws.mediatailor.model.ScheduleConfiguration
        .wrap(impl.scheduleConfiguration())
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val vodSourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vodSourceName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
  ): zio.aws.mediatailor.model.CreateProgramRequest.ReadOnly = new Wrapper(impl)
}
