package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.Type
  ): zio.aws.mediatailor.model.Type = value match {
    case software.amazon.awssdk.services.mediatailor.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.Type.DASH =>
      val r = DASH
      r
    case software.amazon.awssdk.services.mediatailor.model.Type.HLS =>
      val r = HLS
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Type =
      software.amazon.awssdk.services.mediatailor.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object DASH extends zio.aws.mediatailor.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Type =
      software.amazon.awssdk.services.mediatailor.model.Type.DASH
  }
  case object HLS extends zio.aws.mediatailor.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Type =
      software.amazon.awssdk.services.mediatailor.model.Type.HLS
  }
}
