package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class SourceLocation(
    accessConfiguration: Optional[
      zio.aws.mediatailor.model.AccessConfiguration
    ] = Optional.Absent,
    arn: __string,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = Optional.Absent,
    httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration,
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    segmentDeliveryConfigurations: Optional[
      Iterable[zio.aws.mediatailor.model.SegmentDeliveryConfiguration]
    ] = Optional.Absent,
    sourceLocationName: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SourceLocation = {
    import SourceLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SourceLocation
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .arn(arn: java.lang.String)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .httpConfiguration(httpConfiguration.buildAwsValue())
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentDeliveryConfigurations)
      .sourceLocationName(sourceLocationName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.SourceLocation.ReadOnly =
    zio.aws.mediatailor.model.SourceLocation.wrap(buildAwsValue())
}
object SourceLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SourceLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SourceLocation =
      zio.aws.mediatailor.model.SourceLocation(
        accessConfiguration.map(value => value.asEditable),
        arn,
        creationTime.map(value => value),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.asEditable,
        lastModifiedTime.map(value => value),
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceLocationName,
        tags.map(value => value)
      )
    def accessConfiguration
        : Optional[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def arn: __string
    def creationTime: Optional[__timestampUnix]
    def defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    def lastModifiedTime: Optional[__timestampUnix]
    def segmentDeliveryConfigurations: Optional[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ]
    def sourceLocationName: __string
    def tags: Optional[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = ZIO.succeed(httpConfiguration)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSegmentDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "segmentDeliveryConfigurations",
      segmentDeliveryConfigurations
    )
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SourceLocation
  ) extends zio.aws.mediatailor.model.SourceLocation.ReadOnly {
    override val accessConfiguration
        : Optional[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessConfiguration())
        .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val arn: __string = impl.arn(): __string
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val defaultSegmentDeliveryConfiguration: Optional[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : zio.aws.mediatailor.model.HttpConfiguration.ReadOnly =
      zio.aws.mediatailor.model.HttpConfiguration.wrap(impl.httpConfiguration())
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val segmentDeliveryConfigurations: Optional[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.SegmentDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SourceLocation
  ): zio.aws.mediatailor.model.SourceLocation.ReadOnly = new Wrapper(impl)
}
